<?php

namespace Vtlabs\Media\Http\Resources\Media;

use Vtlabs\Media\Models\Comment;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;

class CommentResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'comment' => $this->comment,
            'user' => new UserResource($this->commentator),
            'is_approved' => $this->is_approved,
            'created_at' => $this->created_at,
            'likes_count' => $this->likes()->count(),
            'is_liked' => Auth::check() ? Auth::user()->hasLiked(Comment::find($this->id)) : false,
        ];
    }
}