<?php

namespace Vtlabs\Media\Filters;

use Carbon\Carbon;
use EloquentFilter\ModelFilter;
use Illuminate\Support\Facades\DB;
use Vtlabs\Core\Helpers\CoreHelper;

class CouponFilter extends ModelFilter
{
    public function setup()
    {
        if (!CoreHelper::isAdmin()) {
            $this->whereNull('expires_at')->orWhereDate('expires_at', '>=', Carbon::now());
        }
    }

    public function usedBy($userId)
    {
        $this->whereIn('id', DB::table('media_coupons_users')->select('coupon_id')->where('user_id', $userId)->pluck('coupon_id')->toArray());
    }

    public function unusedOnly($userId) 
    {
        $this->whereNotIn('id', DB::table('media_coupons_users')->select('coupon_id')->where('user_id', $userId)->pluck('coupon_id')->toArray());
    }
}
