<?php

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


use Illuminate\Http\Request;

Route::middleware('api')->prefix('api')->name('api')->namespace('Vtlabs\Media\Http\Controllers\Api')->group(function () {

    // admin api
    Route::namespace('Admin')->name('admin')->prefix('admin')->group(function () {
        Route::middleware('auth:api')->group(function () {
            Route::apiResource('authors', 'AuthorController');
            Route::apiResource('media', 'MediaController');
            Route::apiResource('media-coupons', 'CouponController');
            Route::apiResource('episode', 'EpisodeController');
            Route::apiResource('comments', 'CommentController')->only(['index', 'delete']);
        });
    });

    // app/web api
    Route::prefix('media')->group(function () {
        Route::get('/', 'MediaController@index');
        Route::get('show/{media}', 'MediaController@show');
        Route::put('update-count/{media}', 'MediaController@updateCount');
        Route::get('episodes/{media}', 'MediaController@episodes');
        Route::get('ratings/{media}', 'MediaController@ratingList');
        Route::get('ratings/summary/{media}', 'MediaController@ratingSummary');
        Route::get('stats/{user}', 'MediaController@stats');
        Route::get('hashtags', 'MediaController@getPopularHashtags');

        // likes
        Route::get('likes/list', 'MediaController@likes');
        Route::get('likes/{media}', 'MediaController@likers');
        Route::post('likes/{media}', 'MediaController@toggleLike');

        // comments
        Route::get('comments/{media}', 'MediaController@listComments');
        Route::post('comments/{media}', 'MediaController@createComment');
        Route::put('comments/{comment}', 'MediaController@updateComment');
        Route::delete('comments/{comment}', 'MediaController@deleteComment');
        Route::get('comments/like/{comment}', 'MediaController@commentLikers');
        Route::post('comments/like/{comment}', 'MediaController@toggleCommentLike');

        // comment reply
        Route::get('comments/replies/{comment}', 'MediaController@listReplyComments');
        Route::post('comments/replies/{comment}', 'MediaController@replyComment');

        // author
        Route::get('author', 'AuthorController@index');
        Route::get('author/show/{author}', 'AuthorController@show');
        Route::get('author/episodes/{author}', 'AuthorController@episodes');
        Route::get('author/ratings/{author}', 'AuthorController@ratingList');

        // plan 
        Route::get('plans', 'PlanController@index');

        // coupons
        Route::get('coupons', 'CouponController@index');

        Route::middleware('auth:api')->group(function () {
            Route::post('/', 'MediaController@store');
            Route::delete('delete/{media}', 'MediaController@destroy');
            Route::get('favourites', 'MediaController@favourites');
            Route::get('favourites/media-images', 'MediaController@favouriteMediaImages');
            Route::post('favourites/{media}', 'MediaController@toggleFavourite');
            Route::post('ratings/{media}', 'MediaController@ratingStore');
            Route::post('repost/{media}', 'MediaController@repost');
            Route::post('report/{media}', 'MediaController@report');

            // notify followers
            Route::get('notify-followers', 'MediaController@notifyFollowers');

            // author
            Route::get('author/favourites', 'AuthorController@favourites');
            Route::post('author/favourites/{author}', 'AuthorController@toggleFavourite');
            Route::post('author/ratings/{author}', 'AuthorController@ratingStore');
            Route::get('author/preferences', 'AuthorController@listAuthorPreferences');
            Route::post('author/preferences', 'AuthorController@storeAuthorPreferences');

            // order
            Route::get('orders', 'MediaOrderController@index');
            Route::post('orders/{media}', 'MediaOrderController@store');
            Route::put('orders/{mediaOrder}', 'MediaOrderController@update');

            // plans
            Route::post('plans/{plan}', 'PlanController@purchasePlan');

            // playlists
            Route::get('playlists', 'PlaylistController@index');
            Route::post('playlists', 'PlaylistController@store');
            Route::get('playlists/{playlist}', 'PlaylistController@listMedia');
            Route::post('playlists/{playlist}', 'PlaylistController@addMedia');
            Route::delete('playlists/{playlist}', 'PlaylistController@destroy');

            // coupons
            Route::get('coupons/{coupon}/redeem', 'CouponController@redeem');
        });
    });
});
