<?php

use Vtlabs\Media\Models\Media;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMediaTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('media', function (Blueprint $table) {
            $table->increments('id');
            $table->json('title')->nullable();
            $table->json('description')->nullable();
            $table->json('short_description')->nullable();
            $table->json('meta')->nullable();
            $table->integer('views_count')->default(0);
            $table->integer('shares_count')->default(0);
            $table->string('length')->nullable();
            $table->string('language')->nullable();
            $table->string('artists')->nullable();
            $table->date('release_date')->nullable();
            $table->string('maturity_rating')->nullable();

            $table->enum('status', [Media::STATUS_PUBLISHED, MEDIA::STATUS_UNPUBLISHED, Media::STATUS_DRAFT]);

            $table->integer('category_id')->unsigned()->nullable();
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');

            $table->integer('user_id')->unsigned()->nullable();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->integer('parent_media_id')->unsigned()->nullable();
            $table->foreign('parent_media_id')->references('id')->on('media')->onDelete('cascade');

            $table->timestamps();
        });

        Schema::create('media_categories', function (Blueprint $table) {
            $table->integer('media_id')->unsigned();
            $table->integer('category_id')->unsigned();
            $table->foreign('media_id')->references('id')->on('media')->onDelete('cascade');
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
        });

        Schema::create('media_content', function (Blueprint $table) {
            $table->increments('id');
            $table->json('meta')->nullable();
            $table->string('original_source', 500);
            $table->json('source');
            $table->enum('type', ['clip', 'main'])->default('main');
            $table->integer('media_id')->unsigned();
            $table->foreign('media_id')->references('id')->on('media')->onDelete('cascade');
            $table->timestamps();
        });

        Schema::create('media_episodes', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('season_number');
            $table->integer('episode_number');
            $table->json('meta')->nullable();

            $table->integer('media_id')->unsigned();
            $table->foreign('media_id')->references('id')->on('media')->onDelete('cascade');
            
            $table->integer('parent_media_id')->unsigned();
            $table->foreign('parent_media_id')->references('id')->on('media')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('media_episodes');
        Schema::dropIfExists('media_content');
        Schema::dropIfExists('media_categories');
        Schema::dropIfExists('media');
    }
}
