<?php

namespace Vtlabs\Media\Models;

use EloquentFilter\Filterable;
use Vtlabs\Core\Models\User\User;
use Illuminate\Database\Eloquent\Model;

class Playlist extends Model
{
    use Filterable;

    protected $table = 'playlists';

    protected $guarded = [];

    public function getMediaCountAttribute()
    {
        return $this->medias->count();
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function medias()
    {
        return $this->belongsToMany(Media::class, 'media_playlists')->orderByDesc('media_playlists.created_at');
    }
}