<?php

namespace Vtlabs\Media\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;

class MediaEpisode extends Model
{
    use Filterable;

    protected $table = 'media_episodes';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'array',
    ];

    public function scopeOrdered($query)
    {
        return $query->orderBy('season_number')->orderBy('episode_number');
    }

    public function media()
    {
        return $this->belongsTo(config('vtlabs_media.models.media'), 'media_id');
    }

    public function parent()
    {
        return $this->belongsTo(config('vtlabs_media.models.media'), 'parent_media_id');
    }
}
