<?php

namespace Vtlabs\Media\Models;

use EloquentFilter\Filterable;
use Rennokki\Rating\Traits\CanBeRated;
use Illuminate\Database\Eloquent\Model;
use Rennokki\Rating\Contracts\Rateable;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia\HasMedia;
use ChristianKuri\LaravelFavorite\Traits\Favoriteable;

class Author extends Model implements HasMedia, Rateable
{
    use Filterable,
        HasTranslations,
        Favoriteable,
        CoreHasMediaTrait,
        CanBeRated;

    protected $table = 'authors';

    protected $guarded = [];

    protected $casts = [
        'title' => 'array',
        'short_description' => 'array',
        'description' => 'array',
        'meta' => 'json'
    ];

    public $translatable = ['title', 'description', 'short_description'];

    public function getMediaCountAttribute()
    {
        return $this->medias->count();
    }

    public function getIsFavouriteAttribute()
    {
        return $this->isFavorited();
    }

    public function medias()
    {
        return $this->belongsToMany(Media::class, 'media_authors');
    }
}