<?php

namespace Vtlabs\Media;

use Illuminate\Support\ServiceProvider;

class MediaServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $this->publishes([
            __DIR__.'/../config/vtlabs_media.php' => config_path('vtlabs_media.php'),
        ], 'config');

        $this->loadMigrationsFrom(__DIR__.'/../database/migrations');

        $this->loadRoutesFrom(__DIR__.'/../routes/api.php');

        $this->loadFactoriesFrom(__DIR__.'/../database/factories');
        
        // api responses
        $this->publishes([
            __DIR__.'/../storage/responses' => storage_path('responses'),
        ], 'api_response');

        // translations
        $this->loadTranslationsFrom(__DIR__.'/../resources/lang', 'vtlabs_media');
        $this->publishes([
            __DIR__.'/../resources/lang' => resource_path('lang/vendor/vtlabs_media'),
        ], 'translations');
    }

    /**
     * Register bindings in the container.
     *
     * @return void
     */
    public function register()
    {
    }
}