<?php

namespace Vtlabs\Media\Http\Resources\Media;

use Illuminate\Http\Resources\Json\JsonResource;

class PlaylistResource extends JsonResource
{
    public function toArray($request)
    {
        $medias = $this->medias()->limit(4)->get();
        $images = [];
        
        foreach($medias as $media) {
            array_push($images, $media->getMediaUrlsAttribute()["images"][0]["default"]);
        }

        return [
            'id' => $this->id,
            'title' => $this->title,
            'media_ids' => $this->medias()->select('id')->get()->pluck(['id'])->toArray(),
            'media_count' => $this->media_count,
            'media_images' => $images
        ];
    }
}