<?php

namespace Vtlabs\Media\Http\Resources\Media;

use Vtlabs\Media\Models\Media;
use Vtlabs\Core\Models\User\User;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Category\Http\Resources\CategoryResource;
use Vtlabs\Media\Http\Resources\Media\AuthorResource;

class MediaResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'title_translations' => $this->getTranslations('title'),
            'description' => $this->description,
            'description_translations' => $this->getTranslations('description'),
            'short_description' => $this->short_description,
            'short_description_translations' => $this->getTranslations('short_description'),
            'meta' => $this->meta,
            'price' => $this->price,
            'length' => $this->length,
            'language' => $this->language,
            'artists' => $this->artists,
            'release_date' => $this->release_date,
            'maturity_rating' => $this->maturity_rating,
            'status' => $this->status,
            'medialibrary' => $this->getMediaUrlsAttribute(),
            'user' => new UserResource($this->user),
            'category' => new CategoryResource($this->category),
            'subcategories' => CategoryResource::collection($this->subcategories),
            'authors' => AuthorResource::collection($this->authors),
            'content' => MediaContentResource::collection($this->content),
            'parent' => new MediaResource($this->parent),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'favourite_count' => $this->favoritesCount,
            'is_favourite' => $this->isFavourite,
            'is_purchased' => $this->isPurchased,
            'episode_count' => $this->episodeCount,
            'season_count' => $this->seasonCount,
            'ratings' => $this->averageRating(User::class),
            'ratings_count' => $this->raters(User::class)->count(),
            'likes_count' => $this->likes()->count(),
            'is_liked' => Auth::check() ? Auth::user()->hasLiked(Media::find($this->id)) : false,
            'comments_count' => $this->comments()->count(),
            'views_count' => $this->views_count,
            'shares_count' => $this->shares_count
        ];
    }
}