<?php

namespace Vtlabs\Media\Http\Resources\Media;

use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Core\Http\Resources\UserResource;
use Vtlabs\Media\Models\Media;

class MediaRatingResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'rating' => $this->pivot->rating,
            'review' => $this->pivot->review,
            'created_at' => $this->pivot->created_at,
            'user' => new UserResource($this),
            'media' => new MediaResource(Media::find($this->pivot->rateable_id))
        ];
    }
}