<?php

namespace Vtlabs\Media\Http\Resources\Media;

use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Payment\Http\Resources\PaymentResource;
use Vtlabs\Media\Http\Resources\Media\MediaResource;

class MediaOrderResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'meta' => $this->meta,
            'subtotal' => $this->subtotal,
            'taxes' => $this->taxes,
            'total' => $this->total,
            'discount' => $this->discount,
            'user_id' => $this->user_id,
            'media_id' => $this->media_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'user' => new UserResource($this->user),
            'media' => new MediaResource($this->media),
            'payment' => new PaymentResource($this->payment),
        ];
    }
}