<?php

namespace Vtlabs\Media\Http\Resources\Media;

use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Media\Http\Resources\Media\AuthorResource;
use Vtlabs\Media\Models\Author;

class AuthorRatingResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'rating' => $this->pivot->rating,
            'review' => $this->pivot->review,
            'created_at' => $this->pivot->created_at,
            'user' => new UserResource($this),
            'author' => new AuthorResource(Author::find($this->pivot->rateable_id))
        ];
    }
}