<?php

namespace Vtlabs\Media\Http\Controllers\Api;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Vtlabs\Media\Models\Coupon;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Media\Filters\CouponFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Media\Http\Resources\Media\CouponResource;

class CouponController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:api');
    }

    public function index(Request $request)
    {
        $request->validate([
            'used_by' => 'sometimes|exists:users,id'
        ]);

        if(!$request->used_by) {
            request()->merge([
                "unused_only" => Auth::id()
            ]);
        }

        $coupons = Coupon::filter($request->all(), CouponFilter::class);

        return CouponResource::collection($coupons->get());
    }

    public function redeem(Coupon $coupon, Request $request)
    {
        $coins = $coupon->coins;

        $user = Auth::user();

        try {
            $coupon = Coupon::getCouponFromCode($coupon->code, $user);
        } catch (\Exception $ex) {
            return response()->json(['message' => $ex->getMessage()], 400);
        }

        if ($user->balance >= $coins) {
            $user->withdraw($coins); // update user balance

            // record coupon usage
            $coupon->users()->attach($user->id, [
                'used_at' => Carbon::now(),
            ]);

            return new CouponResource($coupon);
        } else {
            return response()->json(['message' => 'Not enough coins to redeem this offer'], 400);
        }
    }
}
