<?php

namespace Vtlabs\Media\Filters;

use EloquentFilter\ModelFilter;
use Illuminate\Support\Facades\App;
use Vtlabs\Core\Helpers\CoreHelper;

class MediaEpisodeFilter extends ModelFilter
{
    public function setup()
    {
    }

    public function season($season)
    {
        return $this->where('season_number', $season);
    }

    public function seasonNumber($season)
    {
        return $this->where('season_number', $season);
    }

    public function episodeNumber($episode)
    {
        return $this->where('episode_number', $episode);
    }

    public function media($media)
    {
        return $this->whereHas('media', function($query) use ($media) {
            return CoreHelper::searchTranslated($query, 'title', App::getLocale(), $media);
        });
    }

    public function parent($parent)
    {
        return $this->where('parent_media_id', $parent);
    }
}
