<?php

namespace Vtlabs\Gateapp\Models;

use Illuminate\Support\Str;
use EloquentFilter\Filterable;
use Vtlabs\Gateapp\Models\Flat;
use Vtlabs\Core\Models\User\User;
use Vtlabs\Gateapp\Models\Project;
use Spatie\ModelStatus\HasStatuses;
use Vtlabs\Gateapp\Models\Building;
use Illuminate\Database\Eloquent\Model;
use Vtlabs\Core\Helpers\CoreHelper;

class Visitorlog extends Model
{
    use Filterable, HasStatuses;

    const VISITORLOG_STATUS = ['waiting', 'preapproved', 'approved', 'inside', 'rejected', 'left'];
    const VISITORLOG_STATUS_WAITING = 'waiting';
    const VISITORLOG_STATUS_RESOLVED = 'preapproved';
    const VISITORLOG_STATUS_APPROVED = 'approved';
    const VISITORLOG_STATUS_REJECTED = 'rejected';
    const VISITORLOG_STATUS_LEFT = 'left';

    protected $table = 'gateapp_visitorlogs';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json',
        'intime' => 'datetime:Y-m-d H:i:s',
        'outtime' => 'datetime:Y-m-d H:i:s',
        'pax' => 'integer'
    ];

    public static function boot()
    {
        parent::boot();

        // on create
        static::created(function ($visitorlog) {
            $visitorlog->setStatus(self::VISITORLOG_STATUS_WAITING);

            // create a unique referral code for the user
            while (1) {
                $code = CoreHelper::generatePin();
                if (!Visitorlog::where('code', $code)->exists()) {
                    $visitorlog->code = $code;
                    $visitorlog->save();
                    break;
                }
            }
        });
    }

    public function isValidStatus(string $name, ?string $reason = null): bool
    {
        return in_array($name, self::VISITORLOG_STATUS);
    }

    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function building()
    {
        return $this->belongsTo(Building::class);
    }

    public function flat()
    {
        return $this->belongsTo(Flat::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
