<?php

namespace Vtlabs\Gateapp\Models;

use EloquentFilter\Filterable;
use Vtlabs\Gateapp\Models\Flat;
use Vtlabs\Gateapp\Models\Project;
use Spatie\ModelStatus\HasStatuses;
use Vtlabs\Category\Models\Category;
use Illuminate\Database\Eloquent\Model;

class Servicebooking extends Model
{
    use Filterable, HasStatuses;

    const SERVICEBOOKING_STATUS = ['pending', 'approved', 'rejected', 'cancelled'];
    const SERVICEBOOKING_STATUS_PENDING = 'pending';
    const SERVICEBOOKING_STATUS_APPROVED = 'approved';
    const SERVICEBOOKING_STATUS_REJECTED = 'rejected';
    const SERVICEBOOKING_STATUS_CANCELLED = 'cancelled';

    protected $table = 'gateapp_servicebookings';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json'
    ];

    public static function boot()
    {
        parent::boot();

        // on create
        static::created(function ($servicebooking) {
            $servicebooking->setStatus(self::SERVICEBOOKING_STATUS_PENDING);
        });
    }

    public function isValidStatus(string $name, ?string $reason = null): bool
    {
        return in_array($name, self::SERVICEBOOKING_STATUS);
    }

    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function flat()
    {
        return $this->belongsTo(Flat::class);
    }

    public function service()
    {
        return $this->belongsTo(Category::class);
    }
}
