<?php

namespace Vtlabs\Gateapp\Models;

use EloquentFilter\Filterable;
use Vtlabs\Gateapp\Models\Flat;
use Vtlabs\Core\Models\User\User;
use Vtlabs\Gateapp\Models\Project;
use Vtlabs\Gateapp\Models\Building;
use Illuminate\Database\Eloquent\Model;
use Vtlabs\Appointment\Traits\CanAppoint;
use Vtlabs\Appointment\Contracts\Appointer;
use Vtlabs\Payment\Traits\CanPay;

class Resident extends Model implements Appointer
{
    use Filterable, CanAppoint, CanPay;

    protected $table = 'gateapp_residents';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json'
    ];

    public static function findByUser($userId)
    {
        $query = self::where('user_id', $userId);

        return $query->firstOrFail();
    }

    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function building()
    {
        return $this->belongsTo(Building::class);
    }

    public function flat()
    {
        return $this->belongsTo(Flat::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
