<?php

namespace Vtlabs\Gateapp\Models;

use EloquentFilter\Filterable;
use Vtlabs\Gateapp\Models\Flat;
use Vtlabs\Gateapp\Models\Project;
use Spatie\ModelStatus\HasStatuses;
use Vtlabs\Payment\Traits\CanBePaid;
use Vtlabs\Payment\Contracts\Payable;
use Illuminate\Database\Eloquent\Model;

class Paymentrequest extends Model implements Payable
{
    use Filterable, HasStatuses, CanBePaid;

    const PAYMENTREQUEST_STATUS = ['pending', 'paid', 'failed'];
    const PAYMENTREQUEST_PENDING = 'pending';
    const PAYMENTREQUEST_PAID = 'paid';
    const PAYMENTREQUEST_FAILED = 'failed';

    protected $table = 'gateapp_paymentrequests';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json',
        'amount' => 'float',
        'duedate' => 'date:Y-m-d'
    ];

    public function isValidStatus(string $name, ?string $reason = null): bool
    {
        return in_array($name, self::PAYMENTREQUEST_STATUS);
    }


    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function flat()
    {
        return $this->belongsTo(Flat::class);
    }
}
