<?php

namespace Vtlabs\Gateapp\Models;

use EloquentFilter\Filterable;
use Vtlabs\Gateapp\Models\Flat;
use Vtlabs\Core\Models\User\User;
use Spatie\ModelStatus\HasStatuses;
use Illuminate\Database\Eloquent\Model;

class Complaint extends Model
{
    use Filterable, HasStatuses;

    const COMPLAINT_STATUS = ['new', 'resolved'];
    const COMPLAINT_STATUS_NEW = 'new';
    const COMPLAINT_STATUS_RESOLVED = 'resolved';

    protected $table = 'gateapp_complaints';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json'
    ];

    public static function boot()
    {
        parent::boot();

        // on create
        static::created(function ($complaint) {
            $complaint->setStatus(self::COMPLAINT_STATUS_NEW);
        });
    }

    public function isValidStatus(string $name, ?string $reason = null): bool
    {
        return in_array($name, self::COMPLAINT_STATUS);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function project()
    {
        return $this->belongsTo(Project::class, 'project_id');
    }
    
    public function flat()
    {
        return $this->belongsTo(Flat::class);
    }
}
