<?php

namespace Vtlabs\Gateapp\Models;

use EloquentFilter\Filterable;
use Vtlabs\Gateapp\Models\Project;
use Illuminate\Database\Eloquent\Model;
use Vtlabs\Appointment\Models\Appointment;
use Vtlabs\Appointment\Contracts\Appointee;
use Vtlabs\Appointment\Traits\CanBeAppointed;

class Amenity extends Model implements Appointee
{
    use Filterable, CanBeAppointed;

    protected $table = 'gateapp_amenities';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json',
        'fee' => 'float',
        'capacity' => 'integer',
        'booking_capacity' => 'integer',
        'advance_booking_days' => 'integer',
        'max_days_per_flat' => 'integer'
    ];

    public function project()
    {
        return $this->belongsTo(Project::class, 'project_id');
    }

    public function isSlotOccupied(string $date, string $dateTo, string $timeFrom, string $timeTo)
    {
        // @TODO improve slot checking logic
        if ($date != $dateTo) {
            // if dates are different
            return Appointment::where('appointee_id', $this->id)->whereRaw("TIMESTAMP(date,time_from) >= TIMESTAMP('" . $date . "', '" . $timeFrom . "')")
                ->whereRaw("TIMESTAMP(date_to,time_to) <= TIMESTAMP('" . $dateTo . "', '" . $timeTo . "')")->exists();
        } else {
            return Appointment::where('appointee_id', $this->id)
                ->where('date', $date)
                ->where('date_to', $dateTo)
                ->where(function ($query) use ($timeFrom, $timeTo) {
                    return $query->whereBetween('time_from', [$timeFrom, $timeTo])->orWhereBetween('time_to', [$timeFrom, $timeTo]);
                })->exists();
        }
    }

    // public function isSlotOccupied(string $date, string $dateTo, string $timeFrom, string $timeTo)
    // {   // Incrementing timeFrom by a minute to avoid timeTo and timeFrom clash
    //     $timeFromMinuteMore = Carbon::createFromFormat('H:i',$timeFrom)->addMinute()->format('H:i');
    //     // @TODO improve slot checking logic
    //     if ($date != $dateTo) {
    //         // if dates are different
    //         return Appointment::where('appointee_id', $this->id)->whereRaw("TIMESTAMP(date,time_from) >= TIMESTAMP('" . $date . "', '" . $timeFromMinuteMore . "')")
    //             ->whereRaw("TIMESTAMP(date_to,time_to) <= TIMESTAMP('" . $dateTo . "', '" . $timeTo . "')")->exists();
    //     } else {
    //         return Appointment::where('appointee_id', $this->id)
    //             ->where('date', $date)
    //             ->where('date_to', $dateTo)
    //             ->where(function ($query) use ($timeFromMinuteMore, $timeTo) {
    //                 return $query->whereBetween('time_from', [$timeFromMinuteMore, $timeTo])->orWhereBetween('time_to', [$timeFromMinuteMore, $timeTo]);
    //             })->exists();
    //     }
    // }
}
