<?php

namespace Vtlabs\Gateapp\Listeners;

use Vtlabs\Core\Events\RoleAssigned;
use Vtlabs\Gateapp\Models\ProviderProfile;
use Vtlabs\Gateapp\Models\Resident;

class RoleAssignedListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  RoleAssigned $event
     * @return void
     */
    public function handle(RoleAssigned $event)
    {
        if (in_array('customer', $event->roles)) {
            if (!Resident::where('user_id', $event->user->id)->exists()) {
                Resident::create([
                    'user_id' => $event->user->id
                ]);
            }
        }

        return true;
    }
}
