<?php

namespace Vtlabs\Gateapp\Listeners;

use Vtlabs\Core\Events\LoggedIn;
use Vtlabs\Gateapp\Models\Resident;
use Vtlabs\Core\Events\RoleAssigned;
use Vtlabs\Gateapp\Events\PaymentrequestEvent;
use Vtlabs\Gateapp\Events\VisitorlogEvent;
use Vtlabs\Gateapp\Models\Guard;

class PaymentrequestListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  LoggedIn $event
     * @return void
     */
    public function handle(PaymentrequestEvent $event)
    {
        $paymentrequest = $event->paymentrequest;
        $residents = Resident::where('flat_id', $paymentrequest->flat_id)->get();
        if ($event->isNew) {
            // notify user
            foreach($residents as $resident){
                $resident->user->sendPushNotification(
                    'customer',
                    __('vtlabs_gateapp::messages.notification_new_paymentrequest_resident_title', []),
                    __('vtlabs_gateapp::messages.notification_new_paymentrequest_resident_body')
                );
            }          
        }

        return true;
    }
}
