<?php

namespace Vtlabs\Gateapp\Http\Resources;

use Carbon\Carbon;
use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;

class VisitorlogSummaryResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'code' => $this->code,
            'type' => $this->type,
            'name' => $this->name,
            'contact' => $this->contact,
            'company_name' => $this->company_name,
            'vehicle_number' => $this->vehicle_number,
            'pax' => $this->pax,
            'intime' => $this->intime ? (new Carbon($this->intime))->format('Y-m-d H:i:s') : null,
            'outtime' => $this->outtime ? (new Carbon($this->outtime))->format('Y-m-d H:i:s') : null,
            'meta' => $this->meta,
            'status' => $this->status,
            'project_id' => $this->project_id,
            'building_id' => $this->building_id,
            'flat' => new FlatResource($this->flat),
            'user_id' => $this->user_id,
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
            'updated_at' => $this->updated_at->format('Y-m-d H:i:s')
        ];
    }
}
