<?php

namespace Vtlabs\Gateapp\Http\Resources;

use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ResidentResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'type' => $this->type,
            'is_approved' => $this->is_approved,
            'meta' => $this->meta,
            'project_id' => $this->project_id,
            'project' => new ProjectResource($this->project),
            'building_id' => $this->building_id,
            'building' => new BuildingResource($this->building),
            'flat_id' => $this->flat_id,
            'flat' => new FlatResource($this->flat),
            'user_id' => $this->user_id,
            'user' => new UserResource($this->user),
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
            'updated_at' => $this->updated_at->format('Y-m-d H:i:s')
        ];
    }
}
