<?php

namespace Vtlabs\Gateapp\Http\Resources;

use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;

class DirectoryResidentResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'type' => $this->type,
            'is_approved' => $this->is_approved,
            'meta' => $this->meta,
            'project_id' => $this->project_id,
            'building_id' => $this->building_id,
            'flat_id' => $this->flat_id,
            'user_id' => $this->user_id,
            'user' => new UserResource($this->user)
        ];
    }
}

class ProjectDirectoryResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'meta' => $this->meta,
            'residents' => DirectoryResidentResource::collection($this->residents)
        ];
    }
}
