<?php

namespace Vtlabs\Gateapp\Http\Resources;

use Carbon\Carbon;
use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Payment\Http\Resources\PaymentResource;

class PaymentrequestResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'amount' => $this->amount,
            'duedate' => (new Carbon($this->duedate))->format('Y-m-d'),
            'paidon' => $this->paidon ? (new Carbon($this->paidon))->format('Y-m-d') : null,
            'meta' => $this->meta,
            'status' => $this->status,
            'project_id' => $this->project_id,
            'flat_id' => $this->flat_id,
            'payment' => $this->payment ? new PaymentResource($this->payment) : null, 
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
            'updated_at' => $this->updated_at->format('Y-m-d H:i:s')
        ];
    }
}
