<?php

namespace Vtlabs\Gateapp\Http\Resources;

use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ComplaintResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'type' => $this->type,
            'message' => $this->message,
            'status' => $this->status,
            'meta' => $this->meta,
            'user_id' => $this->user_id,
            'user' => new UserResource($this->user),
            'project_id' => $this->project_id,
            'project' => new ProjectResource($this->project),
            'flat_id' => $this->flat_id,
            'flat' => new FlatResource($this->flat),
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
            'updated_at' => $this->updated_at->format('Y-m-d H:i:s')
        ];
    }
}
