<?php

namespace Vtlabs\Gateapp\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Gateapp\Models\Amenity;
use Vtlabs\Gateapp\Models\Resident;
use Vtlabs\Payment\Http\Resources\PaymentResource;

class AppointmentResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'meta' => $this->meta,
            'amount' => $this->amount,
            'amount_meta' => $this->amount_meta,
            'address' => $this->address,
            'address_meta' => $this->address_meta,
            'longitude' => $this->longitude,
            'latitude' => $this->latitude,
            'date' => $this->date,
            'date_to' => $this->date_to,
            'time_from' => $this->time_from,
            'time_to' => $this->time_to,
            'status' => $this->status,
            'resident' => new ResidentResource(Resident::find($this->appointer_id)),
            'amenity' => new AmenityResource(Amenity::find($this->appointee_id)),
            'payment' => new PaymentResource($this->payment),
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
            'updated_at' => $this->updated_at->format('Y-m-d H:i:s')
        ];
    }
}