<?php

namespace Vtlabs\Gateapp\Http\Resources;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Gateapp\Models\Announcement;
use Illuminate\Http\Resources\Json\JsonResource;

class AnnouncementResource extends JsonResource
{
    public function toArray($request)
    {
        $this->loadCount('results');

        return [
            'id' => $this->id,
            'type' => $this->type,
            'message' => $this->message,
            'posted_by' => $this->posted_by,
            'duedate' => (new Carbon($this->duedate))->format('Y-m-d'),
            'meta' => $this->meta,
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
            'updated_at' => $this->updated_at->format('Y-m-d H:i:s'),
            'options' => AnnouncementOptionResource::collection($this->options),
            'likes_count' => $this->likers()->count(),
            'is_liked' => Auth::check() ? Auth::user()->hasLiked(Announcement::find($this->id)) : false,
            'response_count' => $this->results_count
        ];
    }
}
