<?php

namespace Vtlabs\Gateapp\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Gateapp\Models\Flat;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Core\Models\Notification;
use Vtlabs\Gateapp\Models\Servicebooking;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Gateapp\Filters\ServicebookingFilter;
use Vtlabs\Gateapp\Http\Resources\ServicebookingResource;

class ServicebookingController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'flat_id' => 'required'
        ]);

        $servicebookings = Servicebooking::filter($request->all(), ServicebookingFilter::class)->paginate();

        return ServicebookingResource::collection($servicebookings);
    }
    
    public function store(Request $request)
    {
        $request->validate([
            'details' => 'required',
            'service_id' => 'required|exists:categories,id',
            'flat_id' => 'required|exists:gateapp_flats,id',
            'date' => 'required|date_format:Y-m-d',
            'time_from' => 'required|date_format:H:i',
            'meta' => 'sometimes|nullable|json',
        ]);

        $flat = Flat::find($request->flat_id);
        
        $request->merge([
            'project_id' => $flat->building->project_id,
            'meta' => $request->meta ? json_decode($request->meta, true) : null
        ]);

        $servicebooking = Servicebooking::create($request->only(['details', 'service_id', 'flat_id', 'date', 'time_from', 'project_id', 'meta']));

        Notification::create([
            'type' => 'activity',
            'text' => 'Service Booked',
            'meta' => ['servicebooking' => new ServicebookingResource($servicebooking), 'type' => 'servicebooking'],
            'user_id' => Auth::id(),
            'from_user_id' => Auth::id()
        ]);

        return new ServicebookingResource($servicebooking);
    }
}
