<?php

namespace Vtlabs\Gateapp\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Gateapp\Models\Building;
use Vtlabs\Gateapp\Filters\BuildingFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Gateapp\Http\Resources\Admin\BuildingAdminResource;

class BuildingController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'pagination' => 'sometimes|boolean',
            'title' => 'sometimes|string'
        ]);

        $buildings = Building::filter($request->all(), BuildingFilter::class);

        if ($request->pagination == '0') {
            $buildings = $buildings->get();
        } else {
            $buildings = $buildings->paginate();
        }

        return BuildingAdminResource::collection($buildings);
    }
}
