<?php

namespace Vtlabs\Gateapp\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Gateapp\Models\Announcement;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Gateapp\Models\AnnouncementOption;
use Vtlabs\Gateapp\Models\AnnouncementResult;
use Illuminate\Validation\ValidationException;
use Vtlabs\Gateapp\Filters\AnnouncementFilter;
use Vtlabs\Gateapp\Http\Resources\AnnouncementResource;

class AnnouncementController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'project_id' => 'required'
        ]);
        
        $announcements = Announcement::filter($request->all(), AnnouncementFilter::class)->latest();

        return AnnouncementResource::collection($announcements->paginate());
    }

    public function toggleLike(Announcement $announcement, Request $request)
    {
        Auth::user()->toggleLike($announcement);

        $liked = Auth::user()->hasLiked($announcement);

        return response()->json(["like" => $liked]);
    }

    public function submitPoll(Announcement $announcement, Request $request)
    {
        $request->validate([
            'option_id' => 'required'
        ]);

        // check option id belongs to the announcement
        if(!AnnouncementOption::where('announcement_id', $announcement->id)->where('id', $request->option_id)->exists()) {
            throw ValidationException::withMessages(['option_id' => 'Wrong option_id']);
        }

        if(AnnouncementResult::where('announcement_id', $announcement->id)->where('user_id', Auth::id())->exists()) {
            throw ValidationException::withMessages(['user' => 'Already submitted']);
        }
        
        AnnouncementResult::create([
            'option_id' => $request->option_id,
            'announcement_id' => $announcement->id,
            'user_id' => Auth::id(),
        ]);

        return new AnnouncementResource($announcement->fresh());
    }
}
