<?php

namespace Vtlabs\Gateapp\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Gateapp\Models\Amenity;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Gateapp\Filters\AmenityFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Gateapp\Http\Resources\AmenityResource;

class AmenityController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'project_id' => 'required'
        ]);

        $amenitys = Amenity::filter($request->all(), AmenityFilter::class);

        return AmenityResource::collection($amenitys->get());
    }
    
}
