<?php

namespace Vtlabs\Gateapp\Filters;

use Carbon\Carbon;
use EloquentFilter\ModelFilter;

class VisitorlogFilter extends ModelFilter
{
    public function setup()
    {
    }

    public function code($code)
    {
        return $this->where('code', $code);
    }

    public function type($type)
    {
        return $this->where('type', $type);
    }

    public function project($project)
    {
        return $this->where('project_id', $project);
    }

    public function building($building)
    {
        return $this->where('building_id', $building);
    }

    public function flat($flat)
    {
        return $this->where('flat_id', $flat);
    }

    public function status($status)
    {
        return $this->currentStatus($status);
    }

    public function waiting($waiting)
    {
        return $this->currentStatus(['waiting', 'approved']);
    }

    public function household($household)
    {
        return $this->where('type', 'not like', 'household_%');
    }
}
