<?php

namespace Vtlabs\Gateapp\Filters;

use Carbon\Carbon;
use EloquentFilter\ModelFilter;
use Illuminate\Support\Facades\App;
use Vtlabs\Gateapp\Models\Amenity;
use Vtlabs\Gateapp\Models\Resident;

class AppointmentFilter extends ModelFilter
{
    public function setup()
    {
        $this->where('appointer_type', Resident::class)
            ->where('appointee_type', Amenity::class);
    }

    public function appointer($id)
    {
        return $this->where('appointer_id', $id);
        return $this->whereHas('user', function ($query) use ($id) {
            return $query->where('name', 'like', '%' . $id . '%')
                ->orWhere('mobile_number', 'like', '%' . $id . '%')
                ->orWhere('email', 'like', '%' . $id . '%')
                ->orWhere('id', $id);
        });
    }

    public function appointee($id)
    {
        return $this->where('appointee_id', $id);
    }

    public function resident($id)
    {
        return $this->where('appointer_id', $id)->orWhereHasMorph('appointer', Resident::class, function ($query) use ($id) {
            return $query->whereHas('user', function ($query) use ($id) {
                return $query->where('name', 'like', '%' . $id . '%')
                    ->orWhere('mobile_number', 'like', '%' . $id . '%')
                    ->orWhere('email', 'like', '%' . $id . '%')
                    ->orWhere('id', $id);
            });
        });
    }

    public function amenity($id)
    {
        return $this->where('appointee_id', $id)->orWhereHasMorph('appointee', Amenity::class, function ($query) use ($id) {
            return $query->whereLike('title', $id);
        });
    }

    public function date($date)
    {
        return $this->whereLike('date', $date);
    }

    public function status($status)
    {
        return $this->currentStatus($status);
    }

    public function duration($duration)
    {
        $created_at = Carbon::now()->subDays(365 * 5);

        switch ($duration) {
            case 'hours':
                $created_at = Carbon::now()->subDays(1);
                break;
            case 'days':
                $created_at = Carbon::now()->subDays(7);
                break;
            case 'months':
                $created_at = Carbon::now()->subDays(30);
                break;
            case 'years':
                $created_at = Carbon::now()->subDays(365);
                break;
        }

        return $this->whereDate('created_at', '>', $created_at)->whereDate('created_at', '<=', Carbon::now());
    }
}
