<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateServicebookingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gateapp_servicebookings', function (Blueprint $table) {
            $table->increments('id');
            $table->text('details')->nullable();
            $table->date('date');
            $table->time('time_from');
            $table->json('meta')->nullable();
            
            $table->integer('service_id')->unsigned();
            $table->foreign('service_id')->references('id')->on('categories')->onDelete('cascade');

            $table->integer('project_id')->unsigned();
            $table->foreign('project_id')->references('id')->on('gateapp_projects')->onDelete('cascade');
            
            $table->integer('flat_id')->unsigned();
            $table->foreign('flat_id')->references('id')->on('gateapp_flats')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('gateapp_servicebookings', function (Blueprint $table) {
            $table->dropForeign(['category_id']);
            $table->dropForeign(['flat_id']);
        });

        Schema::dropIfExists('gateapp_servicebookings');
    }
}
