<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePaymentrequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gateapp_paymentrequests', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title');
            $table->float('amount');
            $table->date('duedate');
            $table->date('paidon')->nullable(); // @todo update this field on successfull payment
            $table->json('meta')->nullable();

            $table->integer('project_id')->unsigned();
            $table->foreign('project_id')->references('id')->on('gateapp_projects')->onDelete('cascade');

            $table->integer('flat_id')->unsigned();
            $table->foreign('flat_id')->references('id')->on('gateapp_flats')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('gateapp_paymentrequests', function (Blueprint $table) {
            $table->dropForeign(['project_id']);
            $table->dropForeign(['flat_id']);
        });

        Schema::dropIfExists('gateapp_paymentrequests');
    }
}
