<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVisitorlogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gateapp_visitorlogs', function (Blueprint $table) {
            $table->increments('id');
            $table->string('code', 6)->nullable();
            $table->string('type');
            $table->string('name')->nullable();
            $table->string('contact')->nullable();
            $table->string('company_name')->nullable();
            $table->string('vehicle_number')->nullable();
            $table->integer('pax')->default(1);
            $table->datetime('intime')->nullable();
            $table->datetime('outtime')->nullable();
            $table->json('meta')->nullable();

            $table->integer('project_id')->unsigned();
            $table->foreign('project_id')->references('id')->on('gateapp_projects')->onDelete('cascade');

            $table->integer('building_id')->unsigned();
            $table->foreign('building_id')->references('id')->on('gateapp_buildings')->onDelete('cascade');

            $table->integer('flat_id')->unsigned();
            $table->foreign('flat_id')->references('id')->on('gateapp_flats')->onDelete('cascade');

            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('gateapp_visitorlogs', function (Blueprint $table) {
            $table->dropForeign(['project_id']);
            $table->dropForeign(['building_id']);
            $table->dropForeign(['flat_id']);
            $table->dropForeign(['user_id']);
        });

        Schema::dropIfExists('gateapp_visitorlogs');
    }
}
