<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAnnouncementsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gateapp_announcements', function (Blueprint $table) {
            $table->increments('id');

            $table->enum('type', ['announcement', 'poll']);
            $table->string('message');
            $table->string('posted_by');
            $table->date('duedate')->nullable();
            $table->json('meta')->nullable();

            $table->integer('project_id')->unsigned();
            $table->foreign('project_id')->references('id')->on('gateapp_projects')->onDelete('cascade');

            $table->timestamps();
        });

        Schema::create('gateapp_announcement_options', function (Blueprint $table) {
            $table->increments('id');
            $table->string('title');
            $table->integer('announcement_id')->unsigned();
            $table->foreign('announcement_id')->references('id')->on('gateapp_announcements')->onDelete('cascade');
            $table->timestamps();
        });

        Schema::create('gateapp_announcement_option_results', function (Blueprint $table) {
            // calculateing percentage - select (sum(col='Cancelled')/count(*))*100 from t
            $table->increments('id');
            
            $table->integer('option_id')->unsigned();
            $table->foreign('option_id')->references('id')->on('gateapp_announcement_options')->onDelete('cascade');
            
            $table->integer('announcement_id')->unsigned();
            $table->foreign('announcement_id')->references('id')->on('gateapp_announcements')->onDelete('cascade');

            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('gateapp_announcements');
    }
}
