<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateResidentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('gateapp_residents', function (Blueprint $table) {
            $table->increments('id');

            $table->json('meta')->nullable();
            $table->enum('type', ['owner', 'tenant', 'owner_family', 'tenant_family'])->nullable();
            $table->boolean('is_approved')->default(false);

            $table->integer('project_id')->unsigned()->nullable();
            $table->foreign('project_id')->references('id')->on('gateapp_projects')->onDelete('cascade');

            $table->integer('building_id')->unsigned()->nullable();
            $table->foreign('building_id')->references('id')->on('gateapp_buildings')->onDelete('cascade');

            $table->integer('flat_id')->unsigned()->nullable();
            $table->foreign('flat_id')->references('id')->on('gateapp_flats')->onDelete('cascade');

            $table->integer('user_id')->unsigned()->nullable();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('gateapp_residents', function (Blueprint $table) {
            $table->dropForeign(['project_id']);
            $table->dropForeign(['building_id']);
            $table->dropForeign(['falt_id']);
            $table->dropForeign(['user_id']);
        });
        Schema::dropIfExists('gateapp_residents');
    }
}
