<?php

namespace Vtlabs\Gateapp\Providers;

use Vtlabs\Core\Events\LoggedIn;
use Vtlabs\Core\Events\RoleAssigned;
use Vtlabs\Gateapp\Events\VisitorlogEvent;
use Vtlabs\Gateapp\Events\PaymentrequestEvent;
use Vtlabs\Gateapp\Listeners\LoggedInListener;
use Vtlabs\Gateapp\Listeners\VisitorlogListener;
use Vtlabs\Gateapp\Listeners\RoleAssignedListener;
use Vtlabs\Gateapp\Listeners\PaymentrequestListener;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        LoggedIn::class => [LoggedInListener::class],
        RoleAssigned::class => [RoleAssignedListener::class],
        VisitorlogEvent::class => [VisitorlogListener::class],
        PaymentrequestEvent::class => [PaymentrequestListener::class]
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
