<?php

namespace Vtlabs\Gateapp\Models;

use EloquentFilter\Filterable;
use Vtlabs\Core\Helpers\CoreHelper;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Category\Models\Category;
use Illuminate\Database\Eloquent\Model;
use Vtlabs\Core\Models\AdminPermission;

class Project extends Model
{
    use Filterable;

    protected $table = 'gateapp_projects';

    protected $guarded = [];

    protected $casts = [
        'longitude' => 'float',
        'latitude' => 'float',
        'meta' => 'json'
    ];

    public static function permissionedProject()
    {
        // get permissioned projects of current user in admin panel
        if (request()->is('api/admin/*') && !CoreHelper::isAdmin()) {
            return Auth::user()->meta['project_id'] ?? null;
        }
    }

    public function city()
    {
        return $this->belongsTo(Category::class, 'city_id');
    }
}
