<?php

namespace Vtlabs\Gateapp\Models;

use EloquentFilter\Filterable;
use Vtlabs\Core\Models\User\User;
use Vtlabs\Gateapp\Models\Project;
use Illuminate\Database\Eloquent\Model;

class Guard extends Model
{
    use Filterable;

    protected $table = 'gateapp_guards';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json'
    ];

    public static function findByUser($userId)
    {
        $query = self::where('user_id', $userId);

        return $query->firstOrFail();
    }

    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
