<?php

namespace Vtlabs\Gateapp\Models;

use EloquentFilter\Filterable;
use Vtlabs\Gateapp\Models\Building;
use Vtlabs\Gateapp\Models\Resident;
use Illuminate\Database\Eloquent\Model;

class Flat extends Model
{
    use Filterable;

    protected $table = 'gateapp_flats';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json'
    ];

    public function building()
    {
        return $this->belongsTo(Building::class, 'building_id');
    }

    public function residents()
    {
        return $this->hasMany(Resident::class);
    }
}
