<?php

namespace Vtlabs\Gateapp\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Overtrue\LaravelLike\Traits\Likeable;
use Vtlabs\Gateapp\Models\AnnouncementOption;
use Vtlabs\Gateapp\Models\AnnouncementResult;

class Announcement extends Model
{
    use Filterable, Likeable;

    protected $table = 'gateapp_announcements';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json',
        'duedate' => 'date:Y-m-d'
    ];

    public function project()
    {
        return $this->belongsTo(Project::class, 'project_id');
    }

    public function options()
    {
        return $this->hasMany(AnnouncementOption::class);
    }

    public function results()
    {
        return $this->hasMany(AnnouncementResult::class);
    }
}
