<?php

namespace Vtlabs\Gateapp\Listeners;

use Vtlabs\Core\Events\LoggedIn;
use Vtlabs\Gateapp\Models\Resident;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Core\Models\Notification;
use Vtlabs\Gateapp\Events\VisitorlogEvent;
use Vtlabs\Gateapp\Http\Resources\VisitorlogSummaryResource;

class VisitorlogListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  LoggedIn $event
     * @return void
     */
    public function handle(VisitorlogEvent $event)
    {
        $log = $event->vistorlog;
        $residents = Resident::where('flat_id', $log->flat_id)->oldest()->get();
        if ($event->isNew) {
            if ($log->status == 'waiting') {
                // notify user
                foreach($residents as $resident){
                    $resident->user->sendPushNotification(
                        'customer',
                        __('vtlabs_gateapp::messages.notification_new_visitor_resident_title', ['id' => $log->id]),
                        __('vtlabs_gateapp::messages.notification_new_visitor_resident_body')
                    );
                }
            }
        } else {
            if ($log->status != $event->oldStatus) {

                // update vistorlog in notification meta to latest version
                Notification::where('meta->visitor_log->id', $log->id)->update(['meta' => ['visitor_log' => new VisitorlogSummaryResource($log), 'type' => 'visitorlog']]);
                
                if ($log->status == 'preapproved') {
                    Notification::where('meta->visitor_log->id', $log->id)->delete();
                    Notification::create([
                        'type' => 'activity',
                        'text' => 'Preapproved',
                        'meta' => ['visitor_log' => new VisitorlogSummaryResource($log), 'type' => 'visitorlog'],
                        'user_id' => Auth::id(),
                        'from_user_id' => Auth::id()
                    ]);
                }
                
                if ($log->status == 'approved') {
        
                    Notification::where('meta->visitor_log->id', $log->id)->delete();
                    Notification::create([
                        'type' => 'activity',
                        'text' => 'Approved',
                        'meta' => ['visitor_log' => new VisitorlogSummaryResource($log), 'type' => 'visitorlog'],
                        'user_id' => Auth::id(),
                        'from_user_id' => Auth::id()
                    ]);
        
                    $log->user->sendPushNotification(
                        'guard',
                        __('vtlabs_gateapp::messages.notification_approved_visitor_guard_title', ['id' => $log->id]),
                        __('vtlabs_gateapp::messages.notification_approved_visitor_guard_body')
                    );
                }
                if ($log->status == 'inside') {
                    foreach($residents as $resident){
                        $resident->user->sendPushNotification(
                            'customer',
                            __('vtlabs_gateapp::messages.notification_inside_visitor_resident_title', ['id' => $log->id]),
                            __('vtlabs_gateapp::messages.notification_inside_visitor_resident_body')
                        );
                    }
                }
                if ($log->status == 'left') {
                    foreach($residents as $resident){
                        $resident->user->sendPushNotification(
                            'customer',
                            __('vtlabs_gateapp::messages.notification_left_visitor_resident_title', ['id' => $log->id]),
                            __('vtlabs_gateapp::messages.notification_left_visitor_resident_body')
                        );
                    }
                }
                if ($log->status == 'rejected') {
        
                    // delete previous notifications
                    Notification::where('meta->visitor_log->id', $log->id)->delete();
                    Notification::create([
                        'type' => 'activity',
                        'text' => 'Rejected',
                        'meta' => ['visitor_log' => new VisitorlogSummaryResource($log), 'type' => 'visitorlog'],
                        'user_id' => Auth::id(),
                        'from_user_id' => Auth::id()
                    ]);

                    $log->user->sendPushNotification(
                        'guard',
                        __('vtlabs_gateapp::messages.notification_approved_visitor_guard_title', ['id' => $log->id]),
                        __('vtlabs_gateapp::messages.notification_approved_visitor_guard_body')
                    );
                }
            }
        }

        return true;
    }
}
