<?php

namespace Vtlabs\Gateapp\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Gateapp\Http\Resources\ProjectResource;
use Vtlabs\Category\Http\Resources\CategoryResource;

class ServicebookingResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'details' => $this->details,
            'date' => $this->date,
            'time_from' => $this->time_from,
            'meta' => $this->meta,
            'status' => $this->status,
            'project_id' => $this->project_id,
            'project' => new ProjectResource($this->project),
            'flat_id' => $this->flat_id,
            'flat' => new FlatResource($this->flat),
            'service_id' => $this->service_id,
            'service' => new CategoryResource($this->service),
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
            'updated_at' => $this->updated_at->format('Y-m-d H:i:s')
        ];
    }
}
