<?php

namespace Vtlabs\Gateapp\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Gateapp\Http\Resources\BuildingResource;

class FlatResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'meta' => $this->meta,
            'building_id' => $this->building_id,
            'building' => new BuildingResource($this->building),
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
            'updated_at' => $this->updated_at->format('Y-m-d H:i:s')
        ];
    }
}
