<?php

namespace Vtlabs\Gateapp\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Gateapp\Models\Resident;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Gateapp\Filters\ResidentFilter;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Gateapp\Http\Resources\ResidentResource;

class ResidentController extends Controller
{
    public function index(Request $request)
    {
        $residents = Resident::filter($request->all(), ResidentFilter::class)->paginate();

        return ResidentResource::collection($residents);
    }

    public function show(Resident $resident)
    {
        return new ResidentResource($resident);
    }

    public function showMyProfile(Request $request)
    {
        $request->validate([
            'flat_id' => 'requied'
        ]);

        $resident = Resident::findByUser(Auth::user()->id);
        return new ResidentResource($resident);
    }

    public function updateMyProfile(Request $request)
    {
        $request->validate([
            'type' => 'required',
            'project_id' => 'required|exists:gateapp_projects,id',
            'building_id' => 'required|exists:gateapp_buildings,id',
            'flat_id' => 'required|exists:gateapp_flats,id',
            'meta' => 'sometimes|json|nullable',
        ]);

        if ($request->meta) {
            request()->merge(['meta' => $request->meta ? json_decode($request->meta) : null]);
        }

        $resident = Resident::findByUser(Auth::id());
        $resident->fill($request->only(['type', 'meta', 'project_id', 'building_id', 'flat_id']));
        $resident->save();

        return new ResidentResource($resident);
    }
}
